document.addEventListener('DOMContentLoaded',()=>{
    const name = document.querySelector('#name');
    const email = document.querySelector('#email');
    const message = document.querySelector('#message');
    const submitBtn = document.querySelector('button');
    const notice = document.querySelector('#notify');
    const form = document.querySelector('#form');

    submitBtn.onclick = (e)=>{

        e.preventDefault();

        const emailVerify = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email.value);
        var alert;

        if(name.value && emailVerify && message.value){
            alert = `<p style="background:green;text-align:center;border-radius:4px;">Hello ${name.value}, we have received your message. For faster response contact support@higlogs or contact your assigned customer representative!</p>`;
            form.style.display = 'none';
        }else{
            alert= `<p style="background:rgb(139,10,10);text-align:center;border-radius:4px;">Please fill the form correctly!</p>`;
        }
        notice.innerHTML = alert;

        setTimeout(()=>{
            notice.innerHTML = '';
            form.style.display = 'block';
            name.value = '';
            email.value = '';
            message.value = '';
        },15000);
    }
});