document.addEventListener('DOMContentLoaded',()=>{
    const name = document.querySelector('#name');
    const email = document.querySelector('#email');
    const wallet = document.querySelector('#wallet');
    const amount = document.querySelector('#amount');
    const submitBtn = document.querySelector('button');
    const notice = document.querySelector('#notify');
    const form = document.querySelector('#form');

    submitBtn.onclick = (e)=>{

        e.preventDefault();

        const emailVerify = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email.value);
        var alert;

        if(name.value && emailVerify && wallet.value && amount.value){
            alert = `<p style="background:green;text-align:center;border-radius:4px;">Hello ${name.value}, we are currently reviewing the information provided. For faster verification do not submit more than once!</p>`;
            form.style.display = 'none';
        }else{
            alert= `<p style="background:rgb(139,10,10);text-align:center;border-radius:4px;">Please fill the form correctly!</p>`;
        }
        notice.innerHTML = alert;

        setTimeout(()=>{
            notice.innerHTML = '';
            form.style.display = 'block';
            name.value = '';
            email.value = '';
            wallet.value = '';
            amount.value = ''; 
        },8000);
    }
});